/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations.internal;

import java.nio.file.Paths;
import java.util.Locale;
import net.impactdev.impactor.api.text.TextProcessor;
import net.impactdev.impactor.api.translations.TranslationManager;
import net.impactdev.impactor.api.translations.TranslationProvider;
import net.impactdev.impactor.api.translations.repository.TranslationEndpoint;
import net.impactdev.impactor.api.translations.repository.TranslationRepository;
import net.impactdev.impactor.api.utility.collections.mappings.LoadingMap;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.translations.TranslationsModule;
import net.impactdev.impactor.core.translations.internal.TranslationsConfig;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public interface ImpactorTranslations {
    public static final TranslationManager MANAGER = (TranslationManager)TranslationManager.builder().path(Paths.get("config", new String[0]).resolve("impactor").resolve("translations")).fallback(Locale.US).processor(TextProcessor.mini()).repository((TranslationRepository)TranslationRepository.builder().endpoint(TranslationEndpoint.LANGUAGE_SET, "https://metadata.impactdev.net/impactor/translations").endpoint(TranslationEndpoint.DOWNLOADABLE_LANGUAGE, "https://metadata.impactdev.net/impactor/translation/%s").refreshWhen(() -> TranslationsModule.config.get(TranslationsConfig.AUTO_INSTALL)).maxBundleSize(TranslationsModule.config.get(TranslationsConfig.MAX_BUNDLE_SIZE)).maxCacheAge(TranslationsModule.config.get(TranslationsConfig.MAX_CACHE_AGE)).build()).provided(() -> BaseImpactorPlugin.instance().resource(root -> root.resolve("en_us.json"))).build();
    public static final LoadingMap<String, TranslationProvider<?>> REGISTERED = LoadingMap.of(key -> TranslationProvider.create(MANAGER, key));
    public static final TranslationProvider<Component> NO_PERMISSION = ImpactorTranslations.create("permissions.lacking");
    public static final TranslationProvider<Component> ECONOMY_BALANCE = ImpactorTranslations.create("economy.account.balance");
    public static final TranslationProvider<Component> ECONOMY_TRANSFER = ImpactorTranslations.create("economy.transactions.transfer.successful");
    public static final TranslationProvider<Component> ECONOMY_TRANSACTION = ImpactorTranslations.create("economy.transactions.successful");
    public static final TranslationProvider<Component> ECONOMY_CANT_PAY_SELF = ImpactorTranslations.create("economy.transactions.cant-pay-self");
    public static final TranslationProvider<Component> ECONOMY_TRANSACTION_FAILED = ImpactorTranslations.create("economy.transactions.failed");
    public static final TranslationProvider<Component> ECONOMY_BALTOP_CALCULATING = ImpactorTranslations.create("economy.baltop.calculating");
    public static final TranslationProvider<Component> ECONOMY_BALTOP_HEADER = ImpactorTranslations.create("economy.baltop.header");
    public static final TranslationProvider<Component> ECONOMY_BALTOP_ENTRY = ImpactorTranslations.create("economy.baltop.entry");
    public static final TranslationProvider<Component> ECONOMY_BALTOP_FOOTER = ImpactorTranslations.create("economy.baltop.footer");
    public static final TranslationProvider<Component> ECONOMY_TRANSFER_NOT_ALLOWED = ImpactorTranslations.create("economy.transactions.transfer.not-allowed");
    public static final TranslationProvider<Component> ECONOMY_RECEIVE_PAYMENT = ImpactorTranslations.create("economy.payments.receive");
    public static final TranslationProvider<Component> TRANSLATIONS_SEARCHING = ImpactorTranslations.create("translations.searching");
    public static final TranslationProvider<Component> TRANSLATIONS_INFO_HEADER_FOOTER = ImpactorTranslations.create("translations.info.header-footer");
    public static final TranslationProvider<Component> TRANSLATIONS_INFO_LANGUAGE = ImpactorTranslations.create("translations.info.language");
    public static final TranslationProvider<Component> TRANSLATIONS_INFO_PROGRESS = ImpactorTranslations.create("translations.info.progress");
    public static final TranslationProvider<Component> TRANSLATIONS_INFO_CONTRIBUTOR_HEADER = ImpactorTranslations.create("translations.info.contributor.header");
    public static final TranslationProvider<Component> TRANSLATIONS_INFO_CONTRIBUTOR_NAME = ImpactorTranslations.create("translations.info.contributor.name");
    public static final TranslationProvider<Component> TRANSLATIONS_INVALID_LOCALE = ImpactorTranslations.create("translations.info.invalid-locale");
    public static final TranslationProvider<Component> TRANSLATIONS_INSTALLING = ImpactorTranslations.create("translations.installing");
    public static final TranslationProvider<Component> TRANSLATIONS_INSTALLING_LANGUAGE = ImpactorTranslations.create("translations.installing-language");
    public static final TranslationProvider<Component> TRANSLATIONS_INSTALL_COMPLETE = ImpactorTranslations.create("translations.install-complete");
    public static final TranslationProvider<Component> TRANSLATIONS_INSTALL_FAILED = ImpactorTranslations.create("translations.install-failed");
    public static final TranslationProvider<Component> PLATFORM_INFO_GENERATED = ImpactorTranslations.create("platform.info.notify-generated");
    public static final TranslationProvider<Component> INVALID_CLICK_CALLBACK = ImpactorTranslations.create("click-callback.invalid");

    public static <T> TranslationProvider<T> create(@NotNull String key) {
        return REGISTERED.get(key);
    }
}

